<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

include 'db.php';

$response = ["status" => "error", "message" => "Invalid Request"];

try {
    // Get and validate input
    $input = file_get_contents("php://input");
    
    // Basic check for empty input
    if (empty($input)) {
        throw new Exception("Empty request body");
    }

    $data = json_decode($input, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception("Invalid JSON: " . json_last_error_msg());
    }

    // Check required fields
    $requiredFields = ['customerid', 'customername', 'phonenumber', 'address', 'city', 'state', 'pincode'];
    $missingFields = [];
    
    foreach ($requiredFields as $field) {
        if (!isset($data[$field]) || $data[$field] === '') {
            $missingFields[] = $field;
        }
    }

    if (!empty($missingFields)) {
        throw new Exception("Missing required fields: " . implode(', ', $missingFields));
    }

    // Process data
    $customerid = intval($data['customerid']);
    $customername = mysqli_real_escape_string($conn, $data['customername']);
    $companyname = mysqli_real_escape_string($conn, $data['companyname'] ?? '');
    $phonenumber = mysqli_real_escape_string($conn, $data['phonenumber']);
    $address = mysqli_real_escape_string($conn, $data['address']);
    $address2 = mysqli_real_escape_string($conn, $data['address2']);
    $city = mysqli_real_escape_string($conn, $data['city']);
    $state = mysqli_real_escape_string($conn, $data['state']);
    $pincode = mysqli_real_escape_string($conn, $data['pincode']);
    $country = mysqli_real_escape_string($conn, $data['country'] ?? '');
    $is_default = !empty($data['is_default']);
    
    // Handle addressid - it's optional
    $addressid = null;
    if (isset($data['addressid']) && $data['addressid'] !== '') {
        $addressid = intval($data['addressid']);
    }

    // Start transaction
    mysqli_begin_transaction($conn);

    try {

        if ($addressid !== 0) {
            

            $query = "UPDATE address SET 
                      customerid = '$customerid',
                      companyname = '$companyname',
                      customername = '$customername',
                      phonenumber = '$phonenumber',
                      address = '$address',
                      address2 = '$address2',
                      city = '$city',
                      state = '$state',
                      pincode = '$pincode',
                      country = '$country',
                      isdefault = " . ($is_default ? 1 : 0) . "
                      WHERE addressid = $addressid";

            if (!mysqli_query($conn, $query)) {
                throw new Exception("Address update failed: " . mysqli_error($conn));
            }

            // Update customer if default
            if ($is_default) {
                $updateCustomer = "UPDATE customer SET
                                 displayname = '$customername',
                                 address = '$address',
                                 address2 = '$address2',
                                 companyname = '$companyname',
                                 city = '$city',
                                 state = '$state',
                                 pincode = '$pincode',
                                 phonenumber = '$phonenumber'
                                 WHERE id = $customerid";
                
                if (!mysqli_query($conn, $updateCustomer)) {
                    throw new Exception("Customer update failed: " . mysqli_error($conn));
                }
            }
            
            $response = ["status" => "success", "message" => "Address updated"];
        } else {
            // INSERT NEW ADDRESS
            $query = "INSERT INTO address 
                     (customerid, companyname, customername, phonenumber, address,address2, city, state, pincode, country, isdefault)
                     VALUES ('$customerid', '$companyname', '$customername', '$phonenumber', 
                             '$address','$address2' ,'$city', '$state', '$pincode', '$country', " . ($is_default ? 1 : 0) . ")";

            if (mysqli_query($conn, $query)) {
                $addressid = mysqli_insert_id($conn);
                
                if ($is_default) {
                    $updateCustomer = "UPDATE customer SET
                                      displayname = '$companyname',
                                      address = '$address',
                                      address2 ='$address2',
                                      city = '$city',
                                      state = '$state',
                                      pincode = '$pincode',
                                      phonenumber = '$phonenumber'
                                      WHERE id = $customerid";
                    
                    if (!mysqli_query($conn, $updateCustomer)) {
                        throw new Exception("Customer update failed: " . mysqli_error($conn));
                    }
                }
                
                $response = ["status" => "success", "message" => "Address added", "addressid" => $addressid];
            } else {
                throw new Exception("Address insert failed: " . mysqli_error($conn));
            }
        }

        mysqli_commit($conn);
    } catch (Exception $e) {
        mysqli_rollback($conn);
        throw $e; // Re-throw for outer catch
    }
} catch (Exception $e) {
    $response["message"] = $e->getMessage();
    http_response_code(400);
}

echo json_encode($response);
?>